/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.canvas.roles;

import filenet.vw.api.VWApplicationSpaceDefinition;
import filenet.vw.apps.designer.VWDesignerCoreData;
import filenet.vw.toolkit.admin.property.appspace.VWRolesPanel;
import filenet.vw.toolkit.design.canvas.IVWDesignerCanvasPanel;
import filenet.vw.toolkit.design.canvas.roles.VWDesignerRolePropertyPanel;
import filenet.vw.toolkit.design.property.event.IVWCoordinationEventListener;
import filenet.vw.toolkit.design.property.event.VWCoordinationEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JMenu;
import javax.swing.JPanel;

public class VWRoleCanvasPanel
extends JPanel
implements IVWDesignerCanvasPanel,
IVWCoordinationEventListener {
    private VWDesignerCoreData m_designerCoreData = null;
    private VWRolesPanel m_rolesPanel = null;
    private VWDesignerRolePropertyPanel m_rolePropertyPanel = null;

    public VWRoleCanvasPanel(VWDesignerCoreData designerCoreData) {
        this.m_designerCoreData = designerCoreData;
        this.createControls();
        this.updateApplicationSpaceSetting();
        this.m_designerCoreData.getCoordinationEventNotifier().addCoordinationEventListener(this);
    }

    public void notifyListeners() {
        VWApplicationSpaceDefinition appSpaceDef;
        if (this.m_rolesPanel != null && this.m_rolesPanel.isModified() && (appSpaceDef = this.m_rolesPanel.getApplicationSpace()) != null) {
            this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 761, appSpaceDef.getName());
            String[] queueNames = this.m_rolesPanel.getModifiedQueueNames();
            if (queueNames != null) {
                for (int nIndex = 0; nIndex < queueNames.length; ++nIndex) {
                    this.m_designerCoreData.getCoordinationEventNotifier().sendCoordinationEvent(this, 771, queueNames[nIndex]);
                }
            }
            this.m_rolesPanel.resetModifiedFlag();
        }
    }

    public void initializeActionMenu(JMenu actionMenu) {
        if (actionMenu != null) {
            actionMenu.removeAll();
        }
    }

    public void initializeEditMenu(JMenu editMenu) {
        if (editMenu != null) {
            editMenu.removeAll();
        }
    }

    public void releaseReferences() {
        if (this.m_rolesPanel != null) {
            this.m_rolesPanel.removeAll();
            this.m_rolesPanel = null;
        }
        this.m_designerCoreData = null;
    }

    public void handleCoordinationEvent(VWCoordinationEvent event) {
        if (event.getSource() == this) {
            return;
        }
        switch (event.getID()) {
            case 700: 
            case 703: {
                this.updateApplicationSpaceSetting();
                break;
            }
            case 761: {
                if (this.m_rolesPanel == null) break;
                VWApplicationSpaceDefinition appSpaceDef = this.m_designerCoreData.getDataDictionary().getApplicationSpace((String)event.getEventParam());
                this.m_rolesPanel.handleAppSpaceChangeEvent(appSpaceDef);
                break;
            }
            case 770: 
            case 771: 
            case 772: {
                if (this.m_rolePropertyPanel == null) break;
                this.m_rolePropertyPanel.refreshWorkBasketTable();
                break;
            }
            case 757: {
                if (this.m_rolePropertyPanel != null) {
                    this.m_rolePropertyPanel.refreshWorkBasketTable();
                }
                this.updateApplicationSpaceSetting();
            }
        }
    }

    private void createControls() {
        this.setLayout(new BorderLayout(6, 6));
        this.m_rolePropertyPanel = new VWDesignerRolePropertyPanel(this.m_designerCoreData);
        this.m_rolesPanel = new VWRolesPanel(this.m_designerCoreData.getSessionInfo(), this.m_designerCoreData.getDataDictionary(), this.m_rolePropertyPanel);
        this.add((Component)this.m_rolesPanel, "Center");
    }

    private void updateApplicationSpaceSetting() {
        VWApplicationSpaceDefinition appSpaceDef = this.m_designerCoreData.getProcessMenuHelper().getSelectedApplicationSpaceDefinition();
        this.m_rolesPanel.setApplicationSpace(appSpaceDef);
    }
}

